namespace Hive.Unity.Editor
{
    using System.Collections.Generic;

    internal partial class XmlAuth
    {
        internal Facebook facebook;
        internal Google google;
        internal GooglePlayGames googlePlayGames;
        internal Qq qq;
        internal Wechat wechat;
        internal Vk vk;
        internal Line line;
        internal Weverse weverse;
        internal Apple apple;
        internal Steam steam;
        internal X x;
        internal Telegram telegram;

        internal partial class Facebook
        {
            HiveConfigXmlData data;

            internal string appId;
            internal string clientToken;
            internal List<string> permissions;
        }

        internal partial class Google
        {
            HiveConfigXmlData data;

            internal string appId;
            internal string clientId;
            internal string reversedClientId;
            internal string serverClientId;
            internal string deviceFlowClientId;
        }

        internal partial class GooglePlayGames
        {
            HiveConfigXmlData data;

            internal string appId;
            internal string serverClientId;
        }

        internal partial class Qq
        {
            HiveConfigXmlData data;

            internal string appId;
        }

        internal partial class Wechat
        {
            HiveConfigXmlData data;

            internal string appId;
            internal string appSecret;
        }

        internal partial class Vk
        {
            HiveConfigXmlData data;

            internal string appId;
        }

        internal partial class Line
        {
            HiveConfigXmlData data;

            internal string channelId;
        }

        internal partial class Weverse
        {
            HiveConfigXmlData data;

            internal string clientId;
        }

        internal partial class Apple
        {
            HiveConfigXmlData data;

            internal string serviceId;
        }

        internal partial class Steam
        {
            HiveConfigXmlData data;

            internal string realm;
        }

        internal partial class X
        {
            HiveConfigXmlData data;

            internal string clientId;
        }

        internal partial class Telegram
        {
            HiveConfigXmlData data;

            internal string botId;
            internal string botDomain;
        }
    }





    internal partial class XmlAuth
    {
        internal XmlAuth(HiveConfigXmlData data)
        {
            facebook = new Facebook(data);
            google = new Google(data);
            googlePlayGames = new GooglePlayGames(data);
            qq = new Qq(data);
            wechat = new Wechat(data);
            vk = new Vk(data);
            line = new Line(data);
            weverse = new Weverse(data);
            apple = new Apple(data);
            steam = new Steam(data);
            x = new X(data);
            telegram = new Telegram(data);
        }

        internal partial class Facebook
        {
            internal Facebook(HiveConfigXmlData data)
            {
                this.data = data;
                appId = data.Xml.facebookAppID;
                clientToken = data.Xml.facebookClientToken;
                permissions = data.Xml.facebookPermissions;
            }

            internal void Apply()
            {
                data.Xml.facebookAppID = appId;
                data.Xml.facebookClientToken = clientToken;
                data.Xml.facebookPermissions = permissions;
            }
        }

        internal partial class Google
        {
            internal Google(HiveConfigXmlData data)
            {
                this.data = data;
                appId = data.Xml.googlePlayAppID;
                clientId = data.Xml.googleClientID;
                reversedClientId = data.Xml.googleReversedClientID;
                serverClientId = data.Xml.googleServerClientID;
                deviceFlowClientId = data.Xml.googleDeviceFlowClientID;
            }

            internal void Apply()
            {
                data.Xml.googlePlayAppID = appId;
                data.Xml.googleClientID = clientId;
                data.Xml.googleReversedClientID = reversedClientId;
                data.Xml.googleServerClientID = serverClientId;
                data.Xml.googleDeviceFlowClientID = deviceFlowClientId;
            }
        }

        internal partial class GooglePlayGames
        {
            internal GooglePlayGames(HiveConfigXmlData data)
            {
                this.data = data;
                appId = data.Xml.googlePlayGamesAppID;
                serverClientId = data.Xml.googlePlayGamesServerClientID;
            }

            internal void Apply()
            {
                data.Xml.googlePlayGamesAppID = appId;
                data.Xml.googlePlayGamesServerClientID = serverClientId;
            }
        }

        internal partial class Qq
        {
            internal Qq(HiveConfigXmlData data)
            {
                this.data = data;
                appId = data.Xml.qqAppId;
            }

            internal void Apply()
            {
                data.Xml.qqAppId = appId;
            }
        }

        internal partial class Wechat
        {
            internal Wechat(HiveConfigXmlData data)
            {
                this.data = data;
                appId = data.Xml.weChatAppId;
                appSecret = data.Xml.weChatAppSecret;
            }

            internal void Apply()
            {
                data.Xml.weChatAppId = appId;
                data.Xml.weChatAppSecret = appSecret;
            }
        }

        internal partial class Vk
        {
            internal Vk(HiveConfigXmlData data)
            {
                this.data = data;
                appId = data.Xml.vkAppId;
            }

            internal void Apply()
            {
                data.Xml.vkAppId = appId;
            }
        }

        internal partial class Line
        {
            internal Line(HiveConfigXmlData data)
            {
                this.data = data;
                channelId = data.Xml.lineChannelId;
            }

            internal void Apply()
            {
                data.Xml.lineChannelId = channelId;
            }
        }

        internal partial class Weverse
        {
            internal Weverse(HiveConfigXmlData data)
            {
                this.data = data;
                clientId = data.Xml.weverseClientId;
            }

            internal void Apply()
            {
                data.Xml.weverseClientId = clientId;
            }
        }

        internal partial class Apple
        {
            internal Apple(HiveConfigXmlData data)
            {
                this.data = data;
                serviceId = data.Xml.signInWithAppleServiceId;
            }

            internal void Apply()
            {
                data.Xml.signInWithAppleServiceId = serviceId;
            }
        }

        internal partial class Steam
        {
            internal Steam(HiveConfigXmlData data)
            {
                this.data = data;
                realm = data.Xml.steamRealm;
            }

            internal void Apply()
            {
                data.Xml.steamRealm = realm;
            }
        }

        internal partial class X
        {
            internal X(HiveConfigXmlData data)
            {
                this.data = data;
                clientId = data.Xml.xClientId;
            }

            internal void Apply()
            {
                data.Xml.xClientId = clientId;
            }
        }

        internal partial class Telegram
        {
            internal Telegram(HiveConfigXmlData data)
            {
                this.data = data;
                botId = data.Xml.telegramBotId;
                botDomain = data.Xml.telegramBotDomain;
            }

            internal void Apply()
            {
                data.Xml.telegramBotId = botId;
                data.Xml.telegramBotDomain = botDomain;
            }
        }
    }
}